﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Thomas_Erdoesi.Game_Analyzer
{
    public class KeysPacket
    {
        private const byte KEY_HYPERSPACE = 1;
        private const byte KEY_FIRE = 2;
        private const byte KEY_THRUST = 4;
        private const byte KEY_RIGHT = 8;
        private const byte KEY_LEFT = 16;

        private const byte MASK_HYPERSPACE = 254;
        private const byte MASK_FIRE = 253;
        private const byte MASK_THRUST = 251;
        private const byte MASK_RIGHT = 247;
        private const byte MASK_LEFT = 239;

        private byte keys;
        private bool enableFire;

        public byte ping;

        public KeysPacket()
        {
            ping = 0;

            Initialize();
        }

        public void Initialize()
        {
            enableFire = ((keys & KEY_FIRE) == 0);

            keys = 64;
        }

        public byte[] ToByteArray()
        {
            byte[] bytes = new byte[8];

            bytes[0] = (byte)'c';
            bytes[1] = (byte)'t';
            bytes[2] = (byte)'m';
            bytes[3] = (byte)'a';
            bytes[4] = (byte)'m';
            bytes[5] = (byte)'e';
            bytes[6] = keys;
            bytes[7] = ping;

            return bytes;
        }

        public bool Hyperspace
        {
            get { return ((keys & KEY_HYPERSPACE) == KEY_HYPERSPACE); }
            set { if (value) keys |= KEY_HYPERSPACE; else keys &= MASK_HYPERSPACE; } 
        }

        public bool Fire
        {
            get { return ((keys & KEY_FIRE) == KEY_FIRE); }
            set { if (value && enableFire) keys |= KEY_FIRE; else keys &= MASK_FIRE; } 
        }

        public bool Thrust
        {
            get { return ((keys & KEY_THRUST) == KEY_THRUST); }
            set { if (value) keys |= KEY_THRUST; else keys &= MASK_THRUST; } 
        }

        public bool Left
        {
            get { return ((keys & KEY_LEFT) == KEY_LEFT); }
            set { if (value) { Right = false; keys |= KEY_LEFT; } else keys &= MASK_LEFT; } 
        }

        public bool Right
        {
            get { return ((keys & KEY_RIGHT) == KEY_RIGHT); }
            set { if (value) { Left = false; keys |= KEY_RIGHT; } else keys &= MASK_RIGHT; } 
        }
    }
}
